%%%%%%%%%%%%%%%%%%%%%%%
%%%% wavelet transform
clear;
close all;

T = -5:0.1:5;

% F = sign(T);  %%% signal
F = sin(pi*T)+cos(T);
figure
plot(T,F);
% ylim([-1.5,1.5]);


a = 0.1;
b = 0.2;
W = mhat((T-b)/a) / sqrt(a);

figure
plot(T,W);


% A = 0.01:0.01:0.4;  %%% scale

al = 1.2;
A0 = 0.04;

A = A0*al.^(1:15);

WT = zeros(length(A), length(T));

for j1 = 1:length(A)
    a = A(j1);
for k1 = 1:length(T)
    b = T(k1);
    W = mhat((T-b)/a) / sqrt(a);
    WT(j1, k1) = trapz(T, F.*W);
end
end


figure;
imagesc(T,A,WT);
colorbar


R = zeros(1,length(T));

for j1 = 1:length(A)
    a = A(j1);
for k1 = 1:length(T)
    b = T(k1);
    W = mhat((T-b)/a) / sqrt(a);
    R = R + WT(j1, k1)*W;
end
end

figure;
plot(T,R);
